/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于反馈界面的问题界面
 *
 * 修改:
 *      类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.12.15
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported mc_set_issue*/
/* exported mc_feedback_set_issues_comment*/
/* exported mc_feedback_get_issues*/

/* global $ */
/* global mc_sdk_param */

var str_test = "http://localhost:8001";

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    存入问题/设置已解决的问题
 * 参数:
 *    @param {Promise<string>} str_author_id     作者
 *    @param {Promise<string>} str_type     问题类型
 *    @param {Promise<string>} str_title     标题内容
 *    @param {Promise<string>} str_data     OPEN为问题内容 CLOSED为问题ID
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    @param {Promise<String>} error 错误码

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2020.12.14
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_set_issue(str_author_id, str_type, str_title, str_data, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }

    var obj_get_open_list = new mc_sdk_param();

    obj_get_open_list.set_param_clear();
    obj_get_open_list.set_cmd("SET_PARAM");
    obj_get_open_list.set_func("ISSUES");
    obj_get_open_list.set_param_value("USER_ID", "1");
    obj_get_open_list.set_param_value("TYPE", str_type);
    obj_get_open_list.set_param_value("TITLE", str_title);
    obj_get_open_list.set_param_value("VALUE", str_data);

    $.post(str_test + "/api/issues", obj_get_open_list.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var obj_req = new mc_sdk_param();

        obj_req.set_json(result);
        var error = obj_req.get_param_value("ERROR_CODE");

        fun_callback(error);

        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置评论
 * 参数:
 *    @param {Promise<Object>}    obj_val      设置内容
 *    @param {Promise<Function>}  fn_callback  结束回调
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.12.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_feedback_set_issues_comment(obj_val, fn_callback) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if (
        !obj_val.user_id ||
        "boolean" !== typeof obj_val.type ||
        !obj_val.issues_id ||
        !obj_val.value ||
        "boolean" !== typeof obj_val.state
    ) {
        fn_callback(1);
        return;
    }
    // 评论作者id
    var str_user_id = obj_val.user_id;
    // 评论问题所在列表 true / false (未解决/解决)
    var str_type = obj_val.type ? "OPEN" : "CLOSED";
    // 评论问题id
    var str_issues_id = obj_val.issues_id;
    // 评论内容
    var str_value = obj_val.value;
    // 评论状态 ture / flase (回复 / 评论)
    var b_state = obj_val.state;

    var str_state = "COMMENT";

    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_cmd("SET_PARAM");
    obj_sdk_param.set_func("ISSUES_COMMENT");
    obj_sdk_param.set_param_value("USER_ID", str_user_id);
    obj_sdk_param.set_param_value("TYPE", str_type);
    obj_sdk_param.set_param_value("ISSUES_ID", str_issues_id);
    obj_sdk_param.set_param_value("VALUE", str_value);
    if (b_state) {
        str_state = "REPLY";

        var str_reply_id = obj_val.reply_id;

        obj_sdk_param.set_param_value("REPLY_ID", str_reply_id);
    }
    obj_sdk_param.set_param_value("STATE", str_state);

    $.post(str_test + "/api/issues", obj_sdk_param.get_json(), function (result, status) {
        if ("success" !== status) {
            fn_callback(2);
            return;
        }
        var obj_req = new mc_sdk_param();

        obj_req.set_json(result);
        var error = obj_req.get_param_value("ERROR_CODE");

        if ("0x00000000" === error || !error) {
            error = 0;
        }
        fn_callback(error);
        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取内容
 * 参数:
 *    @param {Promise<String>}   str_issues_id  获取ID
 *    @param {Promise<Boolean>}  b_type         获取列表 true/false = OPEN/CLOSED
 *    @param {Promise<Function>} fn_callback    回调函数(问题内容)
 * 返回：
 *    NA
 * 例子：
 *    NA
 * 备注：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.12.24
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_feedback_get_issues(str_issues_id, b_type, fn_callback) {
    if ("function" !== typeof fn_callback) {
        return;
    }

    var obj_get_open_list = new mc_sdk_param();

    obj_get_open_list.set_param_clear();
    obj_get_open_list.set_cmd("GET_PARAM");
    obj_get_open_list.set_func("ISSUES");
    obj_get_open_list.set_param_value("ID", str_issues_id);
    obj_get_open_list.set_param_value("TYPE", b_type ? "OPEN" : "CLOSED");

    $.post(str_test + "/api/issues", obj_get_open_list.get_json(), function (result, status) {
        if ("success" !== status) {
            fn_callback(0);
            return;
        }
        var obj_req = new mc_sdk_param();

        obj_req.set_json(result);
        var error = obj_req.get_param_value("ERROR_CODE");

        if ("0x00000000" !== error || !error) {
            fn_callback(error);
            return;
        }
        fn_callback({
            issue_data: obj_req.get_attr_val(str_issues_id, "VALUE"),
            issue_id: str_issues_id,
            issue_level: obj_req.get_attr_val(str_issues_id, "LEVEL"),
            time: obj_req.get_attr_val(str_issues_id, "TIME"),
            title: obj_req.get_attr_val(str_issues_id, "TITLE"),
            user_id: obj_req.get_attr_val(str_issues_id, "USER_ID"),
            user_name: obj_req.get_attr_val(str_issues_id, "USER_NAME"),
            comment_list: obj_req.get_attr_val(str_issues_id, "COMMENT")
        });
        return;
    });
}
